/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.mechanicalArm;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterBlock;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterTileEntity;
import com.simibubi.create.content.contraptions.components.deployer.DeployerBlock;
import com.simibubi.create.content.contraptions.components.saw.SawBlock;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelBlock;
import com.simibubi.create.content.logistics.block.chute.AbstractChuteBlock;
import com.simibubi.create.content.logistics.block.funnel.AbstractFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.BeltFunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.block.funnel.FunnelTileEntity;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.logistics.block.mechanicalArm.ArmInteractionPointType;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class AllArmInteractionPointTypes {
    public static final BasinType BASIN = AllArmInteractionPointTypes.register("basin", BasinType::new);
    public static final BeltType BELT = AllArmInteractionPointTypes.register("belt", BeltType::new);
    public static final BlazeBurnerType BLAZE_BURNER = AllArmInteractionPointTypes.register("blaze_burner", BlazeBurnerType::new);
    public static final ChuteType CHUTE = AllArmInteractionPointTypes.register("chute", ChuteType::new);
    public static final CrafterType CRAFTER = AllArmInteractionPointTypes.register("crafter", CrafterType::new);
    public static final CrushingWheelsType CRUSHING_WHEELS = AllArmInteractionPointTypes.register("crushing_wheels", CrushingWheelsType::new);
    public static final DeployerType DEPLOYER = AllArmInteractionPointTypes.register("deployer", DeployerType::new);
    public static final DepotType DEPOT = AllArmInteractionPointTypes.register("depot", DepotType::new);
    public static final FunnelType FUNNEL = AllArmInteractionPointTypes.register("funnel", FunnelType::new);
    public static final MillstoneType MILLSTONE = AllArmInteractionPointTypes.register("millstone", MillstoneType::new);
    public static final SawType SAW = AllArmInteractionPointTypes.register("saw", SawType::new);
    public static final CampfireType CAMPFIRE = AllArmInteractionPointTypes.register("campfire", CampfireType::new);
    public static final ComposterType COMPOSTER = AllArmInteractionPointTypes.register("composter", ComposterType::new);
    public static final JukeboxType JUKEBOX = AllArmInteractionPointTypes.register("jukebox", JukeboxType::new);
    public static final RespawnAnchorType RESPAWN_ANCHOR = AllArmInteractionPointTypes.register("respawn_anchor", RespawnAnchorType::new);

    private static <T extends ArmInteractionPointType> T register(String id, Function<ResourceLocation, T> factory) {
        ArmInteractionPointType type = (ArmInteractionPointType)factory.apply(Create.asResource(id));
        ArmInteractionPointType.register(type);
        return (T)type;
    }

    public static void register() {
    }

    public static class BasinType
    extends ArmInteractionPointType {
        public BasinType(ResourceLocation id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AllBlocks.BASIN.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new ArmInteractionPoint(this, level, pos, state);
        }
    }

    public static class BeltType
    extends ArmInteractionPointType {
        public BeltType(ResourceLocation id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AllBlocks.BELT.has(state) && !(level.m_8055_(pos.m_7494_()).m_60734_() instanceof BeltTunnelBlock);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new BeltPoint(this, level, pos, state);
        }
    }

    public static class BlazeBurnerType
    extends ArmInteractionPointType {
        public BlazeBurnerType(ResourceLocation id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AllBlocks.BLAZE_BURNER.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new BlazeBurnerPoint(this, level, pos, state);
        }
    }

    public static class ChuteType
    extends ArmInteractionPointType {
        public ChuteType(ResourceLocation id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AbstractChuteBlock.isChute(state);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new TopFaceArmInteractionPoint(this, level, pos, state);
        }
    }

    public static class CrafterType
    extends ArmInteractionPointType {
        public CrafterType(ResourceLocation id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AllBlocks.MECHANICAL_CRAFTER.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new CrafterPoint(this, level, pos, state);
        }
    }

    public static class CrushingWheelsType
    extends ArmInteractionPointType {
        public CrushingWheelsType(ResourceLocation id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AllBlocks.CRUSHING_WHEEL_CONTROLLER.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new TopFaceArmInteractionPoint(this, level, pos, state);
        }
    }

    public static class DeployerType
    extends ArmInteractionPointType {
        public DeployerType(ResourceLocation id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AllBlocks.DEPLOYER.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new DeployerPoint(this, level, pos, state);
        }
    }

    public static class DepotType
    extends ArmInteractionPointType {
        public DepotType(ResourceLocation id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AllBlocks.DEPOT.has(state) || AllBlocks.WEIGHTED_EJECTOR.has(state) || AllBlocks.TRACK_STATION.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new DepotPoint(this, level, pos, state);
        }
    }

    public static class FunnelType
    extends ArmInteractionPointType {
        public FunnelType(ResourceLocation id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return !(!(state.m_60734_() instanceof AbstractFunnelBlock) || state.m_61138_((Property)FunnelBlock.EXTRACTING) && (Boolean)state.m_61143_((Property)FunnelBlock.EXTRACTING) != false || state.m_61138_(BeltFunnelBlock.SHAPE) && state.m_61143_(BeltFunnelBlock.SHAPE) == BeltFunnelBlock.Shape.PUSHING);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new FunnelPoint(this, level, pos, state);
        }
    }

    public static class MillstoneType
    extends ArmInteractionPointType {
        public MillstoneType(ResourceLocation id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AllBlocks.MILLSTONE.has(state);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new ArmInteractionPoint(this, level, pos, state);
        }
    }

    public static class SawType
    extends ArmInteractionPointType {
        public SawType(ResourceLocation id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return AllBlocks.MECHANICAL_SAW.has(state) && state.m_61143_((Property)SawBlock.FACING) == Direction.UP && ((KineticTileEntity)level.m_7702_(pos)).getSpeed() != 0.0f;
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new DepotPoint(this, level, pos, state);
        }
    }

    public static class CampfireType
    extends ArmInteractionPointType {
        public CampfireType(ResourceLocation id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.m_60734_() instanceof CampfireBlock;
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new CampfirePoint(this, level, pos, state);
        }
    }

    public static class ComposterType
    extends ArmInteractionPointType {
        public ComposterType(ResourceLocation id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.m_60713_(Blocks.f_50715_);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new ComposterPoint(this, level, pos, state);
        }
    }

    public static class JukeboxType
    extends ArmInteractionPointType {
        public JukeboxType(ResourceLocation id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.m_60713_(Blocks.f_50131_);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new JukeboxPoint(this, level, pos, state);
        }
    }

    public static class RespawnAnchorType
    extends ArmInteractionPointType {
        public RespawnAnchorType(ResourceLocation id) {
            super(id);
        }

        @Override
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return state.m_60713_(Blocks.f_50724_);
        }

        @Override
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new RespawnAnchorPoint(this, level, pos, state);
        }
    }

    public static class RespawnAnchorPoint
    extends DepositOnlyArmInteractionPoint {
        public RespawnAnchorPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return Vec3.m_82528_((Vec3i)this.pos).m_82520_(0.5, 1.0, 0.5);
        }

        @Override
        public ItemStack insert(ItemStack stack, boolean simulate) {
            if (!stack.m_150930_(Items.f_42054_)) {
                return stack;
            }
            if (this.cachedState.m_61145_((Property)RespawnAnchorBlock.f_55833_).orElse(4) == 4) {
                return stack;
            }
            if (!simulate) {
                RespawnAnchorBlock.m_55855_((Level)this.level, (BlockPos)this.pos, (BlockState)this.cachedState);
            }
            ItemStack remainder = stack.m_41777_();
            remainder.m_41774_(1);
            return remainder;
        }
    }

    public static class JukeboxPoint
    extends TopFaceArmInteractionPoint {
        public JukeboxPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        public int getSlotCount() {
            return 1;
        }

        @Override
        public ItemStack insert(ItemStack stack, boolean simulate) {
            Item item = stack.m_41720_();
            if (!(item instanceof RecordItem)) {
                return stack;
            }
            if (this.cachedState.m_61145_((Property)JukeboxBlock.f_54254_).orElse(true).booleanValue()) {
                return stack;
            }
            BlockEntity blockEntity = this.level.m_7702_(this.pos);
            if (!(blockEntity instanceof JukeboxBlockEntity)) {
                return stack;
            }
            JukeboxBlockEntity jukeboxBE = (JukeboxBlockEntity)blockEntity;
            if (!jukeboxBE.m_59524_().m_41619_()) {
                return stack;
            }
            ItemStack remainder = stack.m_41777_();
            ItemStack toInsert = remainder.m_41620_(1);
            if (!simulate) {
                jukeboxBE.m_59517_(toInsert);
                this.level.m_7731_(this.pos, (BlockState)this.cachedState.m_61124_((Property)JukeboxBlock.f_54254_, (Comparable)Boolean.valueOf(true)), 2);
                this.level.m_5898_(null, 1010, this.pos, Item.m_41393_((Item)item));
            }
            return remainder;
        }

        @Override
        public ItemStack extract(int slot, int amount, boolean simulate) {
            if (!this.cachedState.m_61145_((Property)JukeboxBlock.f_54254_).orElse(false).booleanValue()) {
                return ItemStack.f_41583_;
            }
            BlockEntity blockEntity = this.level.m_7702_(this.pos);
            if (!(blockEntity instanceof JukeboxBlockEntity)) {
                return ItemStack.f_41583_;
            }
            JukeboxBlockEntity jukeboxBE = (JukeboxBlockEntity)blockEntity;
            ItemStack record = jukeboxBE.m_59524_();
            if (record.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (!simulate) {
                this.level.m_46796_(1010, this.pos, 0);
                jukeboxBE.m_6211_();
                this.level.m_7731_(this.pos, (BlockState)this.cachedState.m_61124_((Property)JukeboxBlock.f_54254_, (Comparable)Boolean.valueOf(false)), 2);
            }
            return record;
        }
    }

    public static class ComposterPoint
    extends ArmInteractionPoint {
        public ComposterPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return Vec3.m_82528_((Vec3i)this.pos).m_82520_(0.5, 0.8125, 0.5);
        }

        @Override
        public void updateCachedState() {
            BlockState oldState = this.cachedState;
            super.updateCachedState();
            if (oldState != this.cachedState) {
                this.cachedHandler.invalidate();
            }
        }

        @Override
        @Nullable
        protected IItemHandler getHandler() {
            if (!this.cachedHandler.isPresent()) {
                this.cachedHandler = LazyOptional.of(() -> {
                    ComposterBlock composterBlock = (ComposterBlock)Blocks.f_50715_;
                    WorldlyContainer container = composterBlock.m_5840_(this.cachedState, (LevelAccessor)this.level, this.pos);
                    SidedInvWrapper insertionHandler = new SidedInvWrapper(container, Direction.UP);
                    SidedInvWrapper extractionHandler = new SidedInvWrapper(container, Direction.DOWN);
                    return new CombinedInvWrapper(new IItemHandlerModifiable[]{insertionHandler, extractionHandler});
                });
            }
            return (IItemHandler)this.cachedHandler.orElse(null);
        }
    }

    public static class CampfirePoint
    extends DepositOnlyArmInteractionPoint {
        public CampfirePoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        public ItemStack insert(ItemStack stack, boolean simulate) {
            BlockEntity blockEntity = this.level.m_7702_(this.pos);
            if (!(blockEntity instanceof CampfireBlockEntity)) {
                return stack;
            }
            CampfireBlockEntity campfireBE = (CampfireBlockEntity)blockEntity;
            Optional recipe = campfireBE.m_59051_(stack);
            if (recipe.isEmpty()) {
                return stack;
            }
            if (simulate) {
                boolean hasSpace = false;
                for (ItemStack campfireStack : campfireBE.m_59065_()) {
                    if (!campfireStack.m_41619_()) continue;
                    hasSpace = true;
                    break;
                }
                if (!hasSpace) {
                    return stack;
                }
                ItemStack remainder = stack.m_41777_();
                remainder.m_41774_(1);
                return remainder;
            }
            ItemStack remainder = stack.m_41777_();
            campfireBE.m_59053_(remainder, ((CampfireCookingRecipe)recipe.get()).m_43753_());
            return remainder;
        }
    }

    public static class FunnelPoint
    extends DepositOnlyArmInteractionPoint {
        public FunnelPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return VecHelper.getCenterOf((Vec3i)this.pos).m_82549_(Vec3.m_82528_((Vec3i)FunnelBlock.getFunnelFacing(this.cachedState).m_122436_()).m_82490_((double)-0.15f));
        }

        @Override
        protected Direction getInteractionDirection() {
            return FunnelBlock.getFunnelFacing(this.cachedState).m_122424_();
        }

        @Override
        public void updateCachedState() {
            BlockState oldState = this.cachedState;
            super.updateCachedState();
            if (oldState != this.cachedState) {
                this.cachedAngles = null;
            }
        }

        @Override
        public ItemStack insert(ItemStack stack, boolean simulate) {
            BlockEntity tileEntity;
            FilteringBehaviour filtering = TileEntityBehaviour.get((BlockGetter)this.level, this.pos, FilteringBehaviour.TYPE);
            InvManipulationBehaviour inserter = TileEntityBehaviour.get((BlockGetter)this.level, this.pos, InvManipulationBehaviour.TYPE);
            if (this.cachedState.m_61145_((Property)BlockStateProperties.f_61448_).orElse(false).booleanValue()) {
                return stack;
            }
            if (inserter == null) {
                return stack;
            }
            if (filtering != null && !filtering.test(stack)) {
                return stack;
            }
            if (simulate) {
                inserter.simulate();
            }
            ItemStack insert = inserter.insert(stack);
            if (!simulate && insert.m_41613_() != stack.m_41613_() && (tileEntity = this.level.m_7702_(this.pos)) instanceof FunnelTileEntity) {
                FunnelTileEntity funnelTileEntity = (FunnelTileEntity)tileEntity;
                funnelTileEntity.onTransfer(stack);
                if (funnelTileEntity.hasFlap()) {
                    funnelTileEntity.flap(true);
                }
            }
            return insert;
        }
    }

    public static class DepotPoint
    extends ArmInteractionPoint {
        public DepotPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return Vec3.m_82528_((Vec3i)this.pos).m_82520_(0.5, 0.875, 0.5);
        }
    }

    public static class DeployerPoint
    extends ArmInteractionPoint {
        public DeployerPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Direction getInteractionDirection() {
            return this.cachedState.m_61145_((Property)DeployerBlock.FACING).orElse(Direction.UP).m_122424_();
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return super.getInteractionPositionVector().m_82549_(Vec3.m_82528_((Vec3i)this.getInteractionDirection().m_122436_()).m_82490_((double)0.65f));
        }

        @Override
        public void updateCachedState() {
            BlockState oldState = this.cachedState;
            super.updateCachedState();
            if (oldState != this.cachedState) {
                this.cachedAngles = null;
            }
        }
    }

    public static class CrafterPoint
    extends ArmInteractionPoint {
        public CrafterPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Direction getInteractionDirection() {
            return this.cachedState.m_61145_(MechanicalCrafterBlock.HORIZONTAL_FACING).orElse(Direction.SOUTH).m_122424_();
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return super.getInteractionPositionVector().m_82549_(Vec3.m_82528_((Vec3i)this.getInteractionDirection().m_122436_()).m_82490_(0.5));
        }

        @Override
        public void updateCachedState() {
            BlockState oldState = this.cachedState;
            super.updateCachedState();
            if (oldState != this.cachedState) {
                this.cachedAngles = null;
            }
        }

        @Override
        public ItemStack extract(int slot, int amount, boolean simulate) {
            BlockEntity te = this.level.m_7702_(this.pos);
            if (!(te instanceof MechanicalCrafterTileEntity)) {
                return ItemStack.f_41583_;
            }
            MechanicalCrafterTileEntity crafter = (MechanicalCrafterTileEntity)te;
            MechanicalCrafterTileEntity.Inventory inventory = crafter.getInventory();
            inventory.allowExtraction();
            ItemStack extract = super.extract(slot, amount, simulate);
            inventory.forbidExtraction();
            return extract;
        }
    }

    public static class BlazeBurnerPoint
    extends DepositOnlyArmInteractionPoint {
        public BlazeBurnerPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        public ItemStack insert(ItemStack stack, boolean simulate) {
            ItemStack input = stack.m_41777_();
            InteractionResultHolder<ItemStack> res = BlazeBurnerBlock.tryInsert(this.cachedState, this.level, this.pos, input, false, false, simulate);
            ItemStack remainder = (ItemStack)res.m_19095_();
            if (input.m_41619_()) {
                return remainder;
            }
            if (!simulate) {
                Containers.m_18992_((Level)this.level, (double)this.pos.m_123341_(), (double)this.pos.m_123342_(), (double)this.pos.m_123343_(), (ItemStack)remainder);
            }
            return input;
        }
    }

    public static class BeltPoint
    extends DepotPoint {
        public BeltPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        public void keepAlive() {
            super.keepAlive();
            BeltTileEntity beltTE = BeltHelper.getSegmentTE((LevelAccessor)this.level, this.pos);
            if (beltTE == null) {
                return;
            }
            TransportedItemStackHandlerBehaviour transport = beltTE.getBehaviour(TransportedItemStackHandlerBehaviour.TYPE);
            if (transport == null) {
                return;
            }
            MutableBoolean found = new MutableBoolean(false);
            transport.handleProcessingOnAllItems(tis -> {
                if (found.isTrue()) {
                    return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
                }
                tis.lockedExternally = true;
                found.setTrue();
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            });
        }
    }

    public static class TopFaceArmInteractionPoint
    extends ArmInteractionPoint {
        public TopFaceArmInteractionPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        protected Vec3 getInteractionPositionVector() {
            return Vec3.m_82528_((Vec3i)this.pos).m_82520_(0.5, 1.0, 0.5);
        }
    }

    public static class DepositOnlyArmInteractionPoint
    extends ArmInteractionPoint {
        public DepositOnlyArmInteractionPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
            super(type, level, pos, state);
        }

        @Override
        public void cycleMode() {
        }

        @Override
        public ItemStack extract(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        @Override
        public int getSlotCount() {
            return 0;
        }
    }
}

